const express = require('express');
const router = express.Router();
const db = require('../db');
const bcrypt = require('bcryptjs');

// Login Page
router.get('/login', (req, res) => {
    res.render('login', { error: null });
});

// Login Process
router.post('/login', async (req, res) => {
    const { username, password } = req.body;
    try {
        const [rows] = await db.execute('SELECT * FROM users WHERE username = ?', [username]);
        
        if (rows.length > 0) {
            const user = rows[0];
            const match = await bcrypt.compare(password, user.password);
            
            if (match) {
                req.session.loggedin = true;
                req.session.username = user.username;
                req.session.role = user.role;
                return res.redirect('/');
            }
        }
        res.render('login', { error: 'Invalid credentials' });
    } catch (err) {
        console.error(err);
        res.render('login', { error: 'Server error' });
    }
});

// Logout
router.get('/logout', (req, res) => {
    req.session.destroy();
    res.redirect('/login');
});

module.exports = router;