CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin', 'user') DEFAULT 'user'
);

CREATE TABLE raw_materials (
    id INT AUTO_INCREMENT PRIMARY KEY,
    code VARCHAR(50) NOT NULL,
    description TEXT NOT NULL
);

CREATE TABLE resin_phrs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    resin VARCHAR(100) NOT NULL,
    phr DECIMAL(10, 2) NOT NULL,
    set_time VARCHAR(50) NOT NULL
);

-- Default Admin (Password: admin123)
-- You must hash passwords in production. For first run, you might insert manually or use the registration logic.
INSERT INTO users (username, password, role) VALUES ('admin', '$2a$10$X.vjV.O.s/F./v.a/V.u.u.u.u.u.u.u.u', 'admin');